module htoclean;

import StdEnv;
import fclc;

n_args :: Int;
n_args = code {
	ccall n_args "-I"
}

program_arg :: !Int -> {#Char};
program_arg i = code {
	ccall program_arg "I-S"
}

split_path_name_in_file_and_directory_name :: !{#Char} -> (!{#Char},{#Char});
split_path_name_in_file_and_directory_name path_name
	# last_backslash_index = find_last_backslash (size path_name-1);
		with {
			find_last_backslash n
				| n<0 || path_name.[n]=='\\'
					= n;
					= find_last_backslash (n-1);
		}
	= (path_name % (0,last_backslash_index),path_name % (last_backslash_index+1,size path_name-1));

write_errors [] stdio
	= stdio;
write_errors [HError string line:l] stdio
	| line<>0
		# stdio=stdio <<< string <<< " [line:" <<< line <<< "]\n";
		= write_errors l stdio;
		# stdio=stdio <<< string <<< '\n';
		= write_errors l stdio;

wait_for_keypress w
	# (stdio,w) = stdio w;
	  stdio = stdio <<< "Press any key to exit";
	  (ok,c,stdio) = freadc stdio;
	  (ok,w) = fclose stdio w;
	= w;

Start w
	# n_arguments=n_args;
	| n_arguments<>2
		# stderr=fwrites "Usage: htoclean h_file_name\n" stderr;
		  stderr=fwrites "Generates a .icl and .dcl file for a c header file\n" stderr;
		  (ok,w) = fclose stderr w;
		= wait_for_keypress w;
		# path_name = program_arg 1;
		  (directory_name,file_name) = split_path_name_in_file_and_directory_name path_name;
		  h_file_name = if (file_name % (size file_name-2,size file_name-1)==".h") (file_name % (0,size file_name-3)) file_name;
		  (errors,w) = accFiles (compile_header directory_name h_file_name) w;
		= case errors of {
			[]	->	w;
			_	# (stdio,w) = stdio w;
		  		  stdio = write_errors errors stdio;
		  		  (ok,w) = fclose stdio w;
				-> wait_for_keypress w;
		  };
